/*******************************************************************
/*  RegUnit.h
/*  Author: Vadim Berman
/*
/*  Description:
/*  declaration of PersonalLog and EventsRegistry classes, making it
/*  possible for the Agents to remember events and to learn from their
/*  past mistakes
/*
/*  The contents of this file are subject to the Brainiac Public License.
/*  Version 1.0 (the "License"); you may not use this file except in
/*  compliance with the License. You may obtain a copy of the License at
/*  http://www.twilightminds.com
/*
/*  Software distributed under the License is distributed on an "AS IS"
/*  basis WITHOUT WARRANTY OF ANY KIND, either express or implied. See
/*  the License for the specific language governing rights and limitations
/*  under the License.
/*
/*  Copyright (C) 1999 Twilight Minds. All rights reserved.
/********************************************************************/
//---------------------------------------------------------------------------
#ifndef RegUnitH
#define RegUnitH
//---------------------------------------------------------------------------
#include "CommonUnit.h"
//---------------------------------------------------------------------------
typedef unsigned char EventType;
//---------------------------------------------------------------------------
typedef struct{
    ID EventID;//which could be action or strategy ID
    ID ObjectiveID;
    ID ObjItemID;
    ID *Witnesses;
    unsigned short WitnessesQty;
    EventType _Type;
} EventEntry;
//---------------------------------------------------------------------------
EXPO void BBECALL AddWitnessToEvent(EventEntry *,ID );
EXPO void BBECALL RemoveWitnessFromEvent(EventEntry *,ID );
EXPO BOOL BBECALL IsEventWitness(EventEntry *,ID );

//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
class EXPO PersonalLog{
public:
    BBECALL PersonalLog();
    BBECALL ~PersonalLog();
    void BBECALL SetInitiatorID(ID);
    ID BBECALL GetInitiatorID();
    unsigned short MaxLogLen;
    //the parameters are: action/strategy ID, Objective, Objective Item
    int BBECALL GetEventIndex(ID,ID,ID,EventType);
    //these 3 are shortcuts for the previous one
    int BBECALL GetPromiseIndex(ID,ID,ID);
    int BBECALL GetFailedActionIndex(ID,ID,ID);
    int BBECALL GetFailedStrategyIndex(ID,ID,ID);
    BOOL BBECALL WasEventWitness(ID,ID,ID,EventType,ID);
    EventEntry *BBECALL GetEvent(unsigned short);
    BOOL BBECALL SetEvent(ID,ID,ID,EventType,unsigned short);
    //if exceeds maximum, overwrite first event
    EventEntry *BBECALL AddEvent(ID,ID,ID,EventType);
    void BBECALL RemoveEvent(unsigned short);
    void BBECALL DisconnectPointer();
protected:
    BOOL BBECALL ReallocLog(int = 0); //given 0 as parameter, used to free memory
    ID InitiatorID;
    unsigned short NextOverwritten,LogLen;
    EventEntry *Log;
};

//---------------------------------------------------------------------------
class EXPO EventsRegistry{
public:
    BBECALL EventsRegistry();
    BBECALL ~EventsRegistry();
    void BBECALL Register(ID,ID,ID,ID,EventType);
    BOOL BBECALL IsEventRegistered(ID,ID,ID,ID,EventType);
    EventEntry *BBECALL GetEventEntry(ID,ID,ID,ID,EventType);
    void BBECALL Unregister(ID,ID,ID,ID,EventType);
    PersonalLog *BBECALL GetInitiatorLog(ID);
    PersonalLog *BBECALL AddInitiatorLog(ID);
    BOOL BBECALL RemoveInitiatorLog(ID);
    void BBECALL Clear();
protected:
    BOOL BBECALL ReallocRegistry(int = 0); //given 0 as parameter, used to free memory
    PersonalLog *Logs;
    unsigned short LogsQty;
};
//---------------------------------------------------------------------------

#endif

